/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.technicalitiesmc.lib.client.screen.widget.Widget;
import com.technicalitiesmc.lib.math.Vec2i;
import com.technicalitiesmc.lib.menu.MenuComponent;
import com.technicalitiesmc.lib.menu.TKMenu;
import com.technicalitiesmc.lib.menu.slot.ColoredSlot;
import com.technicalitiesmc.lib.menu.slot.TKGhostSlot;
import com.technicalitiesmc.lib.network.TKLibNetworkHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class TKMenuScreen<T extends TKMenu>
extends AbstractContainerScreen<T> {
    private final List<Widget> widgets = new ArrayList<Widget>();
    private final ResourceLocation texture;

    public TKMenuScreen(T menu, Inventory playerInv, Component title, ResourceLocation texture, int width, int height) {
        super(menu, playerInv, title);
        this.texture = texture;
        this.f_97726_ = width;
        this.f_97727_ = height;
        this.f_97731_ = this.f_97727_ - 94;
        for (MenuComponent component : ((TKMenu)((Object)menu)).components()) {
            this.add(component.widgetSupplier().get());
        }
    }

    @Deprecated(forRemoval=true)
    public TKMenuScreen(T menu, Inventory playerInv, Component title, ResourceLocation texture) {
        this(menu, playerInv, title, texture, 176, 166);
    }

    protected final void add(Widget widget) {
        this.widgets.add(widget);
    }

    protected ResourceLocation getTexture() {
        return this.texture;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
    }

    protected void m_181908_() {
        super.m_181908_();
        for (MenuComponent component : ((TKMenu)this.f_97732_).components()) {
            component.clientTick();
        }
    }

    public void m_7379_() {
        for (MenuComponent component : ((TKMenu)this.f_97732_).components()) {
            component.onClientClosed();
        }
        super.m_7379_();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.renderWidgets(poseStack, mouseX, mouseY, partialTick);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        this.m_93228_(poseStack, this.f_97735_, (this.f_96544_ - this.f_97727_) / 2, 0, 0, this.f_97726_, this.f_97727_);
        for (Slot slot : ((TKMenu)this.f_97732_).f_38839_) {
            ColoredSlot s;
            int color;
            if (!(slot instanceof ColoredSlot) || (color = (s = (ColoredSlot)slot).getColor()) == 0) continue;
            TKMenuScreen.m_93172_((PoseStack)poseStack, (int)(this.f_97735_ + slot.f_40220_), (int)(this.f_97736_ + slot.f_40221_), (int)(this.f_97735_ + slot.f_40220_ + 16), (int)(this.f_97736_ + slot.f_40221_ + 16), (int)color);
        }
    }

    private void renderWidgets(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("tklib", "textures/gui/widgets.png"));
        poseStack.m_85836_();
        poseStack.m_85837_((double)this.f_97735_, (double)this.f_97736_, 0.0);
        for (Widget widget : this.widgets) {
            if (!widget.enabled()) continue;
            poseStack.m_85836_();
            Vec2i pos = widget.pos();
            poseStack.m_85837_((double)pos.x(), (double)pos.y(), 0.0);
            widget.render(poseStack, mouseX - pos.x(), mouseY - pos.y(), partialTick);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    protected void m_7025_(PoseStack poseStack, int mouseX, int mouseY) {
        super.m_7025_(poseStack, mouseX, mouseY);
        ArrayList<Component> tooltip = new ArrayList<Component>();
        for (Widget widget : this.widgets) {
            if (!widget.enabled()) continue;
            Vec2i pos = widget.pos();
            Vec2i size = widget.size();
            int x1 = this.f_97735_ + pos.x();
            int y1 = this.f_97736_ + pos.y();
            int x2 = x1 + size.x();
            int y2 = y1 + size.y();
            if (mouseX < x1 || mouseX >= x2 || mouseY < y1 || mouseY >= y2) continue;
            widget.addTooltip(mouseX - x1, mouseY - y1, tooltip);
            if (tooltip.isEmpty()) continue;
            this.m_169388_(poseStack, tooltip, Optional.empty(), mouseX, mouseY);
            return;
        }
    }

    public boolean m_6375_(double x, double y, int button) {
        if (this.f_97734_ != null && this.f_97734_ instanceof TKGhostSlot) {
            ItemStack carried = ((TKMenu)this.f_97732_).m_142621_();
            ItemStack placed = carried.m_41777_().m_41620_(this.f_97734_.m_5866_(carried));
            this.f_97734_.m_5852_(placed);
            TKLibNetworkHandler.sendServerboundGhostSlotClick(this.f_97734_.f_40219_);
            return true;
        }
        for (Widget widget : this.widgets) {
            if (!widget.enabled()) continue;
            Vec2i pos = widget.pos();
            Vec2i size = widget.size();
            int x1 = this.f_97735_ + pos.x();
            int y1 = this.f_97736_ + pos.y();
            int x2 = x1 + size.x();
            int y2 = y1 + size.y();
            if (!(x >= (double)x1) || !(x < (double)x2) || !(y >= (double)y1) || !(y < (double)y2) || !widget.onMouseDown(x - (double)x1, y - (double)y1, button)) continue;
            return true;
        }
        return super.m_6375_(x, y, button);
    }

    public boolean m_6348_(double x, double y, int button) {
        for (Widget widget : this.widgets) {
            if (!widget.enabled()) continue;
            Vec2i pos = widget.pos();
            Vec2i size = widget.size();
            int x1 = this.f_97735_ + pos.x();
            int y1 = this.f_97736_ + pos.y();
            int x2 = x1 + size.x();
            int y2 = y1 + size.y();
            if (!(x >= (double)x1) || !(x < (double)x2) || !(y >= (double)y1) || !(y < (double)y2) || !widget.onMouseUp(x - (double)x1, y - (double)y1, button)) continue;
            return true;
        }
        return super.m_6348_(x, y, button);
    }

    public boolean m_6050_(double x, double y, double amount) {
        Slot slot;
        if (this.f_97734_ != null && (slot = this.f_97734_) instanceof TKGhostSlot) {
            TKGhostSlot slot2 = (TKGhostSlot)slot;
            ItemStack stack = slot2.m_7993_();
            if (!stack.m_41619_()) {
                int delta = (int)Math.signum(amount) * (TKMenuScreen.m_96638_() ? 8 : 1);
                stack.m_41764_(Math.max(1, Math.min(stack.m_41613_() + delta, slot2.m_6641_())));
                TKLibNetworkHandler.sendServerboundGhostSlotScroll(this.f_97734_.f_40219_, delta);
            }
            return true;
        }
        for (Widget widget : this.widgets) {
            if (!widget.enabled()) continue;
            Vec2i pos = widget.pos();
            Vec2i size = widget.size();
            int x1 = this.f_97735_ + pos.x();
            int y1 = this.f_97736_ + pos.y();
            int x2 = x1 + size.x();
            int y2 = y1 + size.y();
            if (!(x >= (double)x1) || !(x < (double)x2) || !(y >= (double)y1) || !(y < (double)y2) || !widget.onMouseScrolled(x - (double)x1, y - (double)y1, amount)) continue;
            return true;
        }
        return super.m_6050_(x, y, amount);
    }
}

